<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Http\Requests\StoreCourseRequest;
use App\Http\Requests\UpdateCourseRequest;
use Illuminate\Http\Request;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courses = Course::get();
        return view('courses.list')->with([
            'courses' => $courses,
        ]);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreCourseRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCourseRequest $request)
    {
        $request->validate([
            'title' => 'required|unique:courses',
            'description' => 'required',
            'hours_number' => 'required',
        ], [
            'title.required' => 'يرجى اضافة عنوان البرنامج .',
            'description.required' => 'يرجى اضافة وصف للبرنامج .',
            'hours_number.required' => 'يرجى اضافة عدد ساعات للبرنامج .',
            'title.unique' => 'عنوان هذه البرنامج مستخدم من قبل  .'
        ]);
        try {

            $newCourse = new Course();
            $newCourse->title = $request->title;
            $newCourse->description = $request->description;

            $newCourse->hours_number = $request->hours_number;

            $newCourse->save();

            return back()->with(['success' => 'تم إضافة بيانات البرنامج بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم إضافة بيانات البرنامج  ']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Course  $course
     * @return \Illuminate\Http\Response
     */
    public function show(Course $course)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateCourseRequest  $request
     * @param  \App\Models\Course  $course
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateCourseRequest $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'hours_number' => 'required',
        ], [
            'title.required' => 'يرجى اضافة عنوان البرنامج .',
            'description.required' => 'يرجى اضافة وصف للبرنامج .',
            'hours_number.required' => 'يرجى اضافة عدد ساعات للبرنامج .',
        ]);
        try {

            $newCourse = Course::find($request->id);
            $newCourse->title = $request->title;
            $newCourse->description = $request->description;
            $newCourse->hours_number = $request->hours_number;
            $newCourse->update();

            return back()->with(['success' => 'تم تعديل بيانات البرنامج بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم تعديل بيانات البرنامج  ']);
        }
    }

    /**
     * delete course
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function delete(Request $request)
    {
        try {
            Course::find($request->id)->delete();
            return back()->with(['success' => 'تم حذف البرنامج بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم حذف البرنامج ']);
        }
    }

    /**
     * active and not active course
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function toggle(Request $request)
    {
        try {
            $student = Course::find($request->id);
            $student->is_active *= -1;
            $student->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }
}
